# How to Create the Download Package

## Quick Start

To create a downloadable ZIP package of the Oasis Investor Database System:

### For Linux/Mac Users:
```bash
cd investor-database
chmod +x CREATE_DOWNLOAD.sh
./CREATE_DOWNLOAD.sh
```

### For Windows Users:
```cmd
cd investor-database
CREATE_DOWNLOAD.bat
```

This will create: `oasis-investor-database-v2.0.zip`

---

## Manual Packaging Instructions

If the automated scripts don't work, follow these steps:

### Step 1: Create Package Directory

Create a folder named: `oasis-investor-database-v2.0`

### Step 2: Copy Required Files

Copy these files/folders into the package directory:

#### Root Files (19 files):
- `index.php`
- `test_connection.php`
- `READ_ME_FIRST.txt` (create from template)
- `START_HERE.md`
- `README.md`
- `VERSION.txt`
- `DOWNLOAD_PACKAGE.md`
- `UPLOAD_CHECKLIST.txt`
- `SETUP_INSTRUCTIONS.txt`
- `QUICK_REFERENCE.md`
- `SYSTEM_OVERVIEW.md`
- `DESIGN_IMPROVEMENTS.md`
- `BRANDING_SETUP.md`
- `BRANDING_CHANGES_SUMMARY.md`
- `FILE_MANIFEST.txt`
- `PACKAGE_CONTENTS.txt`
- `PLACE_FAVICON_HERE.txt`
- `.htaccess` (create from template)
- `robots.txt` (create from template)

#### Directories (with all contents):
- `css/` - All files
- `database/` - All files
- `forms/` - All files
- `includes/` - All files
- `image/` - Directory structure + README files

### Step 3: Create Archive

**Windows:**
- Right-click the folder
- Select "Send to > Compressed (zipped) folder"
- Rename to `oasis-investor-database-v2.0.zip`

**Mac:**
- Right-click the folder
- Select "Compress"
- Rename to `oasis-investor-database-v2.0.zip`

**Linux:**
```bash
zip -r oasis-investor-database-v2.0.zip oasis-investor-database-v2.0/
```

---

## What Gets Excluded from Package

The following files/folders are NOT included in the download:

### Development Files:
- `.same/` directory (development tracking)
- `CREATE_DOWNLOAD.sh` (packaging script)
- `CREATE_DOWNLOAD.bat` (packaging script)
- `HOW_TO_CREATE_DOWNLOAD.md` (this file)

### User-Specific Files:
- `favicon.png` (user must upload their own)
- `image/logo/OCFLoogo.png` (user must upload their own)

### Build Artifacts:
- `build/` directory (if exists)
- Any previously created `.zip` files

---

## Package Contents Verification

After creating the package, verify it contains:

### File Count:
- **Total:** 31 files (in clean package)
- **PHP:** 10 files
- **SQL:** 2 files
- **CSS:** 1 file
- **Documentation:** 12 files
- **Security:** 2 files (.htaccess, robots.txt)
- **Info:** 4 files (placeholders, READMEs)

### Directory Structure:
```
oasis-investor-database-v2.0/
├── [19 root files]
├── css/ [1 file]
├── database/ [2 files]
├── forms/ [4 files]
├── includes/ [4 files]
└── image/
    ├── [1 file]
    └── logo/ [2 files]
```

### File Size:
- Uncompressed: ~475KB
- Compressed ZIP: ~150KB
- Package should be under 1MB

---

## Quality Checks

Before distributing the package:

### 1. Test Extraction
- Extract the ZIP to a clean directory
- Verify all files extracted correctly
- Check directory structure is intact

### 2. Test Installation
- Follow the UPLOAD_CHECKLIST.txt
- Import schema.sql to test database
- Configure includes/config.php
- Run test_connection.php
- Verify index.php loads

### 3. Documentation Check
- Open START_HERE.md - readable?
- Open README.md - complete?
- Check all .md files render properly
- Verify instructions are clear

### 4. Code Check
- All PHP files have valid syntax
- No development paths hardcoded
- Config.php has placeholder values
- CSS file is complete

### 5. Package Integrity
```bash
# Linux/Mac - verify file count
unzip -l oasis-investor-database-v2.0.zip | wc -l
# Should show ~35-40 lines (31 files + directories + headers)

# Windows - open ZIP and verify
# Should see 31 files across 4 subdirectories
```

---

## Distribution

### Upload to Server:
```bash
# Example: Upload to web server
scp oasis-investor-database-v2.0.zip user@server:/downloads/
```

### Share with Users:
1. Provide the ZIP file
2. Direct them to extract and read START_HERE.md
3. Point to UPLOAD_CHECKLIST.txt for deployment

### Version Control:
- Keep a copy of each version
- Name format: `oasis-investor-database-vX.X.zip`
- Store VERSION.txt with each package

---

## Automated Script Details

### CREATE_DOWNLOAD.sh (Linux/Mac)

**What it does:**
1. Creates `build/` directory
2. Copies all required files
3. Creates security files (.htaccess, robots.txt)
4. Creates READ_ME_FIRST.txt
5. Packages into ZIP using `zip` command
6. Reports file size and location

**Requirements:**
- `bash` shell
- `zip` command installed
- Execute permissions (`chmod +x`)

**Output:**
- `oasis-investor-database-v2.0.zip` in current directory
- ~150KB compressed size

### CREATE_DOWNLOAD.bat (Windows)

**What it does:**
1. Creates `build\` directory
2. Copies all required files
3. Creates security files
4. Creates READ_ME_FIRST.txt
5. Packages into ZIP using 7-Zip

**Requirements:**
- Windows command prompt
- 7-Zip installed (optional)
- If no 7-Zip: Shows manual instructions

**Output:**
- `oasis-investor-database-v2.0.zip` in current directory
- Instructions if 7-Zip not available

---

## Troubleshooting

### Script Fails:
**Problem:** CREATE_DOWNLOAD.sh gives permission error
**Solution:** Run `chmod +x CREATE_DOWNLOAD.sh`

**Problem:** CREATE_DOWNLOAD.bat can't find 7-Zip
**Solution:** Install 7-Zip or use manual packaging

**Problem:** ZIP file too large (>5MB)
**Solution:** Check for extra files, remove build directory

### Package Issues:
**Problem:** Missing files in package
**Solution:** Check script, verify all `cp/copy` commands

**Problem:** Wrong directory structure
**Solution:** Verify mkdir commands, check paths

**Problem:** Files won't extract
**Solution:** Re-create ZIP, check for corruption

---

## Customizing the Package

### To change version number:

**In CREATE_DOWNLOAD.sh:**
```bash
VERSION="2.0"  # Change this line
```

**In CREATE_DOWNLOAD.bat:**
```batch
set VERSION=2.0  REM Change this line
```

### To add files to package:

Add copy command in appropriate section:
```bash
# Linux/Mac
cp your_file.txt ${PACKAGE_DIR}/

# Windows
copy your_file.txt %PACKAGE_DIR%\
```

### To exclude files:

Simply don't copy them in the script, or add to exclusion list.

---

## Version History

### v2.0 Package:
- Complete Oasis branding
- Modern UI with icons
- 31 files total
- Comprehensive documentation
- Production ready

### v1.0 Package:
- Initial release
- Basic functionality
- 18 files total
- Essential documentation

---

## Support

For questions about packaging:
- See `DOWNLOAD_PACKAGE.md` in package
- Check `PACKAGE_CONTENTS.txt` for file list
- Review `VERSION.txt` for what's new

For user support:
- Direct users to START_HERE.md
- UPLOAD_CHECKLIST.txt for deployment
- README.md for complete docs

---

## Checklist for Package Creation

Before creating package:
- [ ] All files updated to v2.0
- [ ] VERSION.txt reflects current version
- [ ] Documentation is complete
- [ ] No development files included
- [ ] Placeholder files in place
- [ ] Scripts are executable

After creating package:
- [ ] Extract and test
- [ ] Verify file count (31 files)
- [ ] Check directory structure
- [ ] Test installation process
- [ ] Verify documentation renders
- [ ] Package size is reasonable (<1MB)

Ready to distribute:
- [ ] Package tested on clean system
- [ ] START_HERE.md verified
- [ ] All links in docs work
- [ ] No errors in test installation
- [ ] Version number correct

---

**Package Version:** 2.0
**Last Updated:** December 2024
**Status:** Production Ready ✓

**Ready to create your download package!**
