-- Sample Data for Investor Database System
-- This file contains example clients and contact records for testing
-- Import this AFTER schema.sql to see the system with sample data

USE investor_db;

-- Insert sample clients
INSERT INTO clients (
    first_name, last_name, email, phone, mobile, address_line1, city, state_province, postal_code, country,
    kyc_status, kyc_completion_date, kyc_expiry_date, id_type, id_number, tax_id, pep_status, risk_rating,
    date_of_birth, age, nationality, occupation, investor_profile,
    annual_income, income_currency, source_of_income, total_net_worth, net_worth_currency, liquid_assets,
    current_investments, investment_experience, investment_interests, investment_objectives,
    risk_tolerance, investment_horizon, notes, client_status, assigned_staff_id
) VALUES
(
    'Robert', 'Anderson', 'robert.anderson@email.com', '+1-555-1001', '+1-555-1002',
    '123 Wall Street', 'New York', 'NY', '10005', 'United States',
    'Completed', '2024-01-15', '2025-01-15', 'Passport', 'US123456789', 'TAX-001', 'No', 'Low',
    '1975-06-15', 48, 'American', 'CEO - Technology Company',
    'Experienced investor with background in technology sector. Looking for diversified portfolio with focus on sustainable investments.',
    850000.00, 'USD', 'Business income from technology company, consulting fees', 5200000.00, 'USD', 2100000.00,
    'Mix of equities (60%), bonds (30%), real estate (10%). Primary holdings in tech sector and sustainable energy.',
    'Extensive', 'Equities, Sustainable Energy, Real Estate, Private Equity',
    'Long-term wealth preservation with moderate growth. Focus on sustainable and ESG-compliant investments.',
    'Moderate', 'Long-term', 'High net worth client. Interested in ESG investments. Regular quarterly reviews preferred.',
    'Active', 1
),
(
    'Jennifer', 'Martinez', 'j.martinez@email.com', '+1-555-2001', '+1-555-2002',
    '456 Park Avenue', 'New York', 'NY', '10022', 'United States',
    'Completed', '2024-03-20', '2025-03-20', 'Driver License', 'DL987654321', 'TAX-002', 'No', 'Medium',
    '1985-09-22', 38, 'American', 'Medical Professional',
    'Medical doctor seeking to build wealth for retirement. Conservative approach with steady returns.',
    320000.00, 'USD', 'Medical practice income', 1800000.00, 'USD', 450000.00,
    'Primarily bonds (50%), mutual funds (30%), stocks (20%). Focus on healthcare and pharmaceutical sectors.',
    'Moderate', 'Healthcare, Bonds, Mutual Funds, Index Funds',
    'Retirement planning with capital preservation. Target retirement age 60.',
    'Conservative', 'Long-term', 'Monthly contributions of $5,000. Risk-averse investor.',
    'Active', 2
),
(
    'William', 'Chen', 'william.chen@email.com', '+44-20-5551001', '+44-20-5551002',
    '10 Downing Street', 'London', 'Greater London', 'SW1A 2AA', 'United Kingdom',
    'In Progress', '2024-11-01', NULL, 'Passport', 'UK789456123', 'TAX-003-UK', 'No', 'High',
    '1968-03-10', 55, 'British', 'Entrepreneur',
    'Serial entrepreneur with multiple successful exits. High risk tolerance and interest in venture capital.',
    1500000.00, 'GBP', 'Business sales, venture capital investments', 15000000.00, 'GBP', 5000000.00,
    'Venture capital (40%), private equity (30%), equities (20%), alternative investments (10%).',
    'Extensive', 'Venture Capital, Private Equity, Startups, Cryptocurrency, Alternative Investments',
    'Aggressive growth strategy. Interested in early-stage tech startups and emerging markets.',
    'Aggressive', 'Medium-term', 'Very experienced investor. Prefers high-risk, high-reward opportunities.',
    'Active', 3
),
(
    'Maria', 'Schmidt', 'maria.schmidt@email.com', '+49-30-5551001', '+49-30-5551002',
    'Unter den Linden 1', 'Berlin', 'Berlin', '10117', 'Germany',
    'Completed', '2024-02-10', '2025-02-10', 'National ID', 'DE456789123', 'TAX-004-DE', 'No', 'Low',
    '1990-11-28', 33, 'German', 'Software Engineer',
    'Young professional starting investment journey. Focus on sustainable long-term growth.',
    95000.00, 'EUR', 'Employment income - software engineering', 280000.00, 'EUR', 120000.00,
    'Index funds (60%), individual stocks (25%), savings (15%). Tech-heavy portfolio.',
    'Limited', 'Index Funds, Technology Stocks, ETFs, Sustainable Investments',
    'Building wealth for future family. Long-term growth with monthly contributions.',
    'Moderate', 'Long-term', 'Monthly savings plan of €2,000. First-time serious investor.',
    'Active', 4
),
(
    'Thomas', 'O\'Brien', 'thomas.obrien@email.com', '+353-1-5551001', '+353-1-5551002',
    '15 O\'Connell Street', 'Dublin', 'Dublin', 'D01 F5P2', 'Ireland',
    'Pending', NULL, NULL, 'Passport', 'IE321654987', '', 'Unknown', 'Medium',
    '1978-07-04', 45, 'Irish', 'Business Consultant',
    'Consultant interested in diversifying income streams. New to investment banking.',
    180000.00, 'EUR', 'Consulting business income', 650000.00, 'EUR', 200000.00,
    'Limited - mainly savings accounts and company pension fund.',
    'None', 'Bonds, Mutual Funds, Real Estate Investment Trusts',
    'Learn about investment options and build diversified portfolio.',
    'Conservative', 'Medium-term', 'New client. Requires education on investment products. KYC in progress.',
    'Prospect', 5
),
(
    'Sophie', 'Dubois', 'sophie.dubois@email.com', '+33-1-5551001', '+33-1-5551002',
    '25 Avenue des Champs-Élysées', 'Paris', 'Île-de-France', '75008', 'France',
    'Expired', '2023-06-15', '2024-06-15', 'National ID', 'FR789123456', 'TAX-005-FR', 'No', 'Medium',
    '1982-02-14', 41, 'French', 'Fashion Executive',
    'Executive in luxury fashion industry. Interested in luxury goods and real estate investments.',
    420000.00, 'EUR', 'Executive compensation and bonuses', 3200000.00, 'EUR', 900000.00,
    'Real estate (40%), luxury goods stocks (30%), bonds (20%), cash (10%).',
    'Moderate', 'Real Estate, Luxury Goods, Bonds, Art Investment',
    'Wealth preservation with focus on tangible assets. Interest in art and collectibles.',
    'Moderate', 'Long-term', 'KYC expired - needs renewal. Prefers in-person meetings.',
    'Active', 1
);

-- Insert sample contact records
INSERT INTO contact_records (
    client_id, staff_id, contact_date, contact_type, subject, description, outcome, follow_up_required, follow_up_date
) VALUES
(1, 1, '2024-01-20 10:00:00', 'Visit', 'Initial Portfolio Review',
 'Comprehensive review of existing portfolio. Discussed ESG investment options and sustainable energy sector opportunities.',
 'Client interested in reallocating 20% of portfolio to sustainable investments. Agreed to prepare proposal.',
 1, '2024-02-15'),

(1, 1, '2024-02-18 14:30:00', 'Phone Call', 'ESG Investment Proposal',
 'Presented sustainable investment proposal including renewable energy ETFs and ESG-focused mutual funds.',
 'Client approved proposal. Initiated reallocation process. Very satisfied with recommendations.',
 0, NULL),

(2, 2, '2024-03-25 09:00:00', 'Visit', 'Onboarding Meeting',
 'New client onboarding. Reviewed investment objectives, risk tolerance, and time horizon. Completed KYC documentation.',
 'Established conservative investment strategy focused on bonds and mutual funds. Set up monthly contribution plan.',
 1, '2024-04-25'),

(2, 2, '2024-04-30 11:00:00', 'Phone Call', 'First Month Review',
 'Checked in on first month of investments. Reviewed performance and answered questions about market fluctuations.',
 'Client comfortable with strategy. Confirmed monthly contributions. No changes needed.',
 0, NULL),

(3, 3, '2024-11-05 15:00:00', 'Video Conference', 'Venture Capital Opportunities',
 'Discussed emerging VC opportunities in AI and biotech sectors. Reviewed term sheets for two potential investments.',
 'Client interested in both opportunities. Requested additional due diligence reports.',
 1, '2024-11-20'),

(4, 4, '2024-02-15 13:00:00', 'Email', 'Monthly Newsletter - February 2024',
 'Sent monthly market update and investment insights newsletter.',
 'Newsletter delivered successfully.',
 0, NULL),

(4, 4, '2024-06-10 10:30:00', 'Phone Call', 'Portfolio Rebalancing',
 'Discussed portfolio performance and rebalancing needs. Client concerned about tech sector concentration.',
 'Recommended diversification into international markets. Client approved strategy.',
 1, '2024-07-10'),

(5, 5, '2024-11-15 09:30:00', 'Visit', 'KYC Documentation',
 'Meeting to complete KYC documentation. Reviewed identification documents and conducted due diligence.',
 'KYC process in progress. Awaiting final verification of tax documentation.',
 1, '2024-12-01'),

(6, 1, '2024-06-20 11:00:00', 'Email', 'KYC Renewal Reminder',
 'Sent reminder that KYC documentation is expiring and needs renewal.',
 'Email sent. No response yet.',
 1, '2024-07-15'),

(6, 1, '2024-08-05 14:00:00', 'Phone Call', 'KYC Renewal Follow-up',
 'Follow-up call regarding expired KYC. Scheduled in-person meeting to complete renewal.',
 'Meeting scheduled for next week. Client apologized for delay.',
 1, '2024-08-12'),

(1, 1, '2024-09-15 10:00:00', 'Newsletter', 'Q3 Market Insights',
 'Quarterly newsletter covering market trends, ESG investment performance, and upcoming opportunities.',
 'Newsletter delivered successfully.',
 0, NULL),

(3, 3, '2024-11-25 16:00:00', 'Video Conference', 'Due Diligence Review',
 'Reviewed detailed due diligence reports for AI startup investments. Discussed risk factors and potential returns.',
 'Client committed $500K to first investment. Still evaluating second opportunity.',
 1, '2024-12-10');

-- Update last contact dates for clients
UPDATE clients SET last_contact_date = '2024-09-15 10:00:00' WHERE client_id = 1;
UPDATE clients SET last_contact_date = '2024-04-30 11:00:00' WHERE client_id = 2;
UPDATE clients SET last_contact_date = '2024-11-25 16:00:00' WHERE client_id = 3;
UPDATE clients SET last_contact_date = '2024-06-10 10:30:00' WHERE client_id = 4;
UPDATE clients SET last_contact_date = '2024-11-15 09:30:00' WHERE client_id = 5;
UPDATE clients SET last_contact_date = '2024-08-05 14:00:00' WHERE client_id = 6;

-- Show summary
SELECT 'Sample data imported successfully!' as Status;
SELECT CONCAT('Total Clients: ', COUNT(*)) as Summary FROM clients;
SELECT CONCAT('Total Contact Records: ', COUNT(*)) as Summary FROM contact_records;
SELECT CONCAT('Total Staff: ', COUNT(*)) as Summary FROM staff;
