<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/auth.php';

require_role('Admin'); // Only admins can view activity log

$page_title = 'Activity Log';

// Get filter parameters
$filter_user = isset($_GET['user_id']) ? intval($_GET['user_id']) : '';
$filter_action = isset($_GET['action']) ? sanitize_input($_GET['action']) : '';
$filter_entity = isset($_GET['entity_type']) ? sanitize_input($_GET['entity_type']) : '';
$filter_date_from = isset($_GET['date_from']) ? sanitize_input($_GET['date_from']) : '';
$filter_date_to = isset($_GET['date_to']) ? sanitize_input($_GET['date_to']) : '';

// Build query
$where_clauses = [];

if ($filter_user) {
    $where_clauses[] = "al.user_id = $filter_user";
}

if ($filter_action) {
    $where_clauses[] = "al.action = '$filter_action'";
}

if ($filter_entity) {
    $where_clauses[] = "al.entity_type = '$filter_entity'";
}

if ($filter_date_from) {
    $where_clauses[] = "DATE(al.created_at) >= '$filter_date_from'";
}

if ($filter_date_to) {
    $where_clauses[] = "DATE(al.created_at) <= '$filter_date_to'";
}

$where_sql = count($where_clauses) > 0 ? 'WHERE ' . implode(' AND ', $where_clauses) : '';

// Get activity log
$limit = 100;
$log_query = "SELECT al.*, u.username, u.first_name, u.last_name
              FROM activity_log al
              LEFT JOIN users u ON al.user_id = u.user_id
              $where_sql
              ORDER BY al.created_at DESC
              LIMIT $limit";
$log_result = $conn->query($log_query);

// Get all users for filter
$users_query = "SELECT user_id, username, first_name, last_name FROM users ORDER BY username";
$users_result = $conn->query($users_query);

// Get distinct actions
$actions_query = "SELECT DISTINCT action FROM activity_log ORDER BY action";
$actions_result = $conn->query($actions_query);

// Get distinct entity types
$entities_query = "SELECT DISTINCT entity_type FROM activity_log WHERE entity_type IS NOT NULL ORDER BY entity_type";
$entities_result = $conn->query($entities_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-history"></i> Activity Log</h2>

<div class="card">
    <div class="card-header"><i class="fas fa-filter"></i> Filter Activities</div>

    <form method="GET" action="">
        <div class="form-row">
            <div class="form-group">
                <label for="user_id">User</label>
                <select id="user_id" name="user_id">
                    <option value="">-- All Users --</option>
                    <?php while($user = $users_result->fetch_assoc()): ?>
                        <option value="<?php echo $user['user_id']; ?>"
                                <?php echo $filter_user == $user['user_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($user['username'] . ' (' . $user['first_name'] . ' ' . $user['last_name'] . ')'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="action">Action</label>
                <select id="action" name="action">
                    <option value="">-- All Actions --</option>
                    <?php while($action = $actions_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($action['action']); ?>"
                                <?php echo $filter_action == $action['action'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($action['action']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="entity_type">Entity Type</label>
                <select id="entity_type" name="entity_type">
                    <option value="">-- All Types --</option>
                    <?php while($entity = $entities_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($entity['entity_type']); ?>"
                                <?php echo $filter_entity == $entity['entity_type'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($entity['entity_type']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="date_from">Date From</label>
                <input type="date" id="date_from" name="date_from" value="<?php echo htmlspecialchars($filter_date_from); ?>">
            </div>

            <div class="form-group">
                <label for="date_to">Date To</label>
                <input type="date" id="date_to" name="date_to" value="<?php echo htmlspecialchars($filter_date_to); ?>">
            </div>
        </div>

        <div style="margin-top: 1rem;">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            <a href="activity_log.php" class="btn btn-secondary">
                <i class="fas fa-eraser"></i> Clear Filters
            </a>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> Recent Activities
        <?php if ($where_sql): ?>
            <small>(Filtered - Showing up to <?php echo $limit; ?> results)</small>
        <?php else: ?>
            <small>(Showing last <?php echo $limit; ?> activities)</small>
        <?php endif; ?>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Date/Time</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>Entity Type</th>
                    <th>Entity ID</th>
                    <th>Description</th>
                    <th>IP Address</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($log_result->num_rows > 0): ?>
                    <?php while($log = $log_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $log['log_id']; ?></td>
                            <td><?php echo date('Y-m-d H:i:s', strtotime($log['created_at'])); ?></td>
                            <td>
                                <?php if ($log['username']): ?>
                                    <strong><?php echo htmlspecialchars($log['username']); ?></strong><br>
                                    <small><?php echo htmlspecialchars($log['first_name'] . ' ' . $log['last_name']); ?></small>
                                <?php else: ?>
                                    <em>Unknown</em>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge" style="background: <?php
                                    $color = '#3498db';
                                    if (strpos($log['action'], 'login') !== false) $color = '#27ae60';
                                    if (strpos($log['action'], 'logout') !== false) $color = '#95a5a6';
                                    if (strpos($log['action'], 'create') !== false) $color = '#3498db';
                                    if (strpos($log['action'], 'update') !== false) $color = '#f39c12';
                                    if (strpos($log['action'], 'delete') !== false) $color = '#e74c3c';
                                    echo $color;
                                ?>; color: white;">
                                    <?php echo htmlspecialchars($log['action']); ?>
                                </span>
                            </td>
                            <td><?php echo $log['entity_type'] ? htmlspecialchars($log['entity_type']) : '-'; ?></td>
                            <td><?php echo $log['entity_id'] ?? '-'; ?></td>
                            <td><?php echo $log['description'] ? htmlspecialchars($log['description']) : '-'; ?></td>
                            <td><small><?php echo htmlspecialchars($log['ip_address']); ?></small></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center; padding: 2rem; color: #95a5a6;">
                            <i class="fas fa-inbox" style="font-size: 3rem; opacity: 0.3;"></i>
                            <p>No activities found</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-info-circle"></i> Activity Log Information</div>
    <div style="padding: 1.5rem;">
        <p><strong>What is logged:</strong></p>
        <ul style="margin: 1rem 0; padding-left: 2rem;">
            <li>User login and logout</li>
            <li>Create, update, and delete actions on clients, contacts, staff, introducers</li>
            <li>User management actions (create, edit, delete users)</li>
            <li>Password changes</li>
            <li>Failed login attempts</li>
        </ul>

        <p><strong>Data retention:</strong> Activity logs are kept indefinitely for audit purposes.</p>
        <p><strong>Privacy:</strong> Only administrators can view the activity log.</p>
    </div>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
