<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Client Form';
$edit_mode = false;
$client_data = [];
$message = '';
$message_type = '';

// Check if editing existing client
if (isset($_GET['id'])) {
    $edit_mode = true;
    $client_id = intval($_GET['id']);

    $query = "SELECT * FROM clients WHERE client_id = $client_id";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $client_data = $result->fetch_assoc();
    } else {
        $message = "Client not found.";
        $message_type = "error";
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize inputs
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $email = sanitize_input($_POST['email']);
    $phone = sanitize_input($_POST['phone']);
    $mobile = sanitize_input($_POST['mobile']);
    $address_line1 = sanitize_input($_POST['address_line1']);
    $address_line2 = sanitize_input($_POST['address_line2']);
    $city = sanitize_input($_POST['city']);
    $state_province = sanitize_input($_POST['state_province']);
    $postal_code = sanitize_input($_POST['postal_code']);
    $country = sanitize_input($_POST['country']);

    // KYC Information
    $kyc_status = sanitize_input($_POST['kyc_status']);
    $kyc_completion_date = !empty($_POST['kyc_completion_date']) ? sanitize_input($_POST['kyc_completion_date']) : NULL;
    $kyc_expiry_date = !empty($_POST['kyc_expiry_date']) ? sanitize_input($_POST['kyc_expiry_date']) : NULL;
    $id_type = sanitize_input($_POST['id_type']);
    $id_number = sanitize_input($_POST['id_number']);
    $id_expiry_date = !empty($_POST['id_expiry_date']) ? sanitize_input($_POST['id_expiry_date']) : NULL;
    $tax_id = sanitize_input($_POST['tax_id']);
    $pep_status = sanitize_input($_POST['pep_status']);
    $risk_rating = sanitize_input($_POST['risk_rating']);

    // Personal Information
    $date_of_birth = !empty($_POST['date_of_birth']) ? sanitize_input($_POST['date_of_birth']) : NULL;
    $age = !empty($date_of_birth) ? calculate_age($date_of_birth) : NULL;
    $nationality = sanitize_input($_POST['nationality']);
    $occupation = sanitize_input($_POST['occupation']);
    $investor_profile = sanitize_input($_POST['investor_profile']);

    // Financial Information
    $annual_income = !empty($_POST['annual_income']) ? floatval($_POST['annual_income']) : NULL;
    $income_currency = sanitize_input($_POST['income_currency']);
    $source_of_income = sanitize_input($_POST['source_of_income']);
    $total_net_worth = !empty($_POST['total_net_worth']) ? floatval($_POST['total_net_worth']) : NULL;
    $net_worth_currency = sanitize_input($_POST['net_worth_currency']);
    $liquid_assets = !empty($_POST['liquid_assets']) ? floatval($_POST['liquid_assets']) : NULL;

    // Investment Information
    $current_investments = sanitize_input($_POST['current_investments']);
    $investment_experience = sanitize_input($_POST['investment_experience']);
    $investment_interests = sanitize_input($_POST['investment_interests']);
    $investment_objectives = sanitize_input($_POST['investment_objectives']);
    $risk_tolerance = sanitize_input($_POST['risk_tolerance']);
    $investment_horizon = sanitize_input($_POST['investment_horizon']);

    // Additional Information
    $notes = sanitize_input($_POST['notes']);
    $client_status = sanitize_input($_POST['client_status']);
    $assigned_staff_id = !empty($_POST['assigned_staff_id']) ? intval($_POST['assigned_staff_id']) : NULL;
    $introducer_id = !empty($_POST['introducer_id']) ? intval($_POST['introducer_id']) : NULL;
    $owner_staff_id = !empty($_POST['owner_staff_id']) ? intval($_POST['owner_staff_id']) : NULL;

    if ($edit_mode && !empty($client_data)) {
        // Update existing client
        $update_query = "UPDATE clients SET
            first_name = '$first_name',
            last_name = '$last_name',
            email = '$email',
            phone = '$phone',
            mobile = '$mobile',
            address_line1 = '$address_line1',
            address_line2 = '$address_line2',
            city = '$city',
            state_province = '$state_province',
            postal_code = '$postal_code',
            country = '$country',
            kyc_status = '$kyc_status',
            kyc_completion_date = " . ($kyc_completion_date ? "'$kyc_completion_date'" : "NULL") . ",
            kyc_expiry_date = " . ($kyc_expiry_date ? "'$kyc_expiry_date'" : "NULL") . ",
            id_type = '$id_type',
            id_number = '$id_number',
            id_expiry_date = " . ($id_expiry_date ? "'$id_expiry_date'" : "NULL") . ",
            tax_id = '$tax_id',
            pep_status = '$pep_status',
            risk_rating = '$risk_rating',
            date_of_birth = " . ($date_of_birth ? "'$date_of_birth'" : "NULL") . ",
            age = " . ($age ? $age : "NULL") . ",
            nationality = '$nationality',
            occupation = '$occupation',
            investor_profile = '$investor_profile',
            annual_income = " . ($annual_income ? $annual_income : "NULL") . ",
            income_currency = '$income_currency',
            source_of_income = '$source_of_income',
            total_net_worth = " . ($total_net_worth ? $total_net_worth : "NULL") . ",
            net_worth_currency = '$net_worth_currency',
            liquid_assets = " . ($liquid_assets ? $liquid_assets : "NULL") . ",
            current_investments = '$current_investments',
            investment_experience = '$investment_experience',
            investment_interests = '$investment_interests',
            investment_objectives = '$investment_objectives',
            risk_tolerance = '$risk_tolerance',
            investment_horizon = '$investment_horizon',
            notes = '$notes',
            client_status = '$client_status',
            assigned_staff_id = " . ($assigned_staff_id ? $assigned_staff_id : "NULL") . ",
            introducer_id = " . ($introducer_id ? $introducer_id : "NULL") . ",
            owner_staff_id = " . ($owner_staff_id ? $owner_staff_id : "NULL") . "
            WHERE client_id = {$client_data['client_id']}";

        if ($conn->query($update_query) === TRUE) {
            $message = "Client updated successfully!";
            $message_type = "success";
            // Refresh client data
            $result = $conn->query("SELECT * FROM clients WHERE client_id = {$client_data['client_id']}");
            $client_data = $result->fetch_assoc();
        } else {
            $message = "Error updating client: " . $conn->error;
            $message_type = "error";
        }
    } else {
        // Insert new client
        $insert_query = "INSERT INTO clients (
            first_name, last_name, email, phone, mobile, address_line1, address_line2,
            city, state_province, postal_code, country, kyc_status, kyc_completion_date,
            kyc_expiry_date, id_type, id_number, id_expiry_date, tax_id, pep_status,
            risk_rating, date_of_birth, age, nationality, occupation, investor_profile,
            annual_income, income_currency, source_of_income, total_net_worth,
            net_worth_currency, liquid_assets, current_investments, investment_experience,
            investment_interests, investment_objectives, risk_tolerance, investment_horizon,
            notes, client_status, assigned_staff_id, introducer_id, owner_staff_id
        ) VALUES (
            '$first_name', '$last_name', '$email', '$phone', '$mobile', '$address_line1',
            '$address_line2', '$city', '$state_province', '$postal_code', '$country',
            '$kyc_status', " . ($kyc_completion_date ? "'$kyc_completion_date'" : "NULL") . ",
            " . ($kyc_expiry_date ? "'$kyc_expiry_date'" : "NULL") . ", '$id_type', '$id_number',
            " . ($id_expiry_date ? "'$id_expiry_date'" : "NULL") . ", '$tax_id', '$pep_status',
            '$risk_rating', " . ($date_of_birth ? "'$date_of_birth'" : "NULL") . ",
            " . ($age ? $age : "NULL") . ", '$nationality', '$occupation', '$investor_profile',
            " . ($annual_income ? $annual_income : "NULL") . ", '$income_currency', '$source_of_income',
            " . ($total_net_worth ? $total_net_worth : "NULL") . ", '$net_worth_currency',
            " . ($liquid_assets ? $liquid_assets : "NULL") . ", '$current_investments',
            '$investment_experience', '$investment_interests', '$investment_objectives',
            '$risk_tolerance', '$investment_horizon', '$notes', '$client_status',
            " . ($assigned_staff_id ? $assigned_staff_id : "NULL") . ",
            " . ($introducer_id ? $introducer_id : "NULL") . ",
            " . ($owner_staff_id ? $owner_staff_id : "NULL") . "
        )";

        if ($conn->query($insert_query) === TRUE) {
            $message = "Client created successfully!";
            $message_type = "success";
            $new_client_id = $conn->insert_id;
            // Redirect to edit mode
            header("Location: client_form.php?id=$new_client_id");
            exit();
        } else {
            $message = "Error creating client: " . $conn->error;
            $message_type = "error";
        }
    }
}

// Get staff members for dropdown
$staff_query = "SELECT staff_id, first_name, last_name FROM staff WHERE active = 1 ORDER BY last_name, first_name";
$staff_result = $conn->query($staff_query);

// Get introducers for dropdown
$introducers_query = "SELECT introducer_id, company_name, contact_person FROM introducers WHERE introducer_status = 'Active' ORDER BY company_name";
$introducers_result = $conn->query($introducers_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-<?php echo $edit_mode ? 'user-edit' : 'user-plus'; ?>"></i> <?php echo $edit_mode ? 'Edit Client' : 'Add New Client'; ?></h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<form method="POST" action="">

    <!-- Contact Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-address-card"></i> Contact Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="first_name">First Name *</label>
                <input type="text" id="first_name" name="first_name" required
                       value="<?php echo htmlspecialchars($client_data['first_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="last_name">Last Name *</label>
                <input type="text" id="last_name" name="last_name" required
                       value="<?php echo htmlspecialchars($client_data['last_name'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="email">Email *</label>
                <input type="email" id="email" name="email" required
                       value="<?php echo htmlspecialchars($client_data['email'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="tel" id="phone" name="phone"
                       value="<?php echo htmlspecialchars($client_data['phone'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="mobile">Mobile</label>
                <input type="tel" id="mobile" name="mobile"
                       value="<?php echo htmlspecialchars($client_data['mobile'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="address_line1">Address Line 1</label>
                <input type="text" id="address_line1" name="address_line1"
                       value="<?php echo htmlspecialchars($client_data['address_line1'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="address_line2">Address Line 2</label>
                <input type="text" id="address_line2" name="address_line2"
                       value="<?php echo htmlspecialchars($client_data['address_line2'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="city">City</label>
                <input type="text" id="city" name="city"
                       value="<?php echo htmlspecialchars($client_data['city'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="state_province">State/Province</label>
                <input type="text" id="state_province" name="state_province"
                       value="<?php echo htmlspecialchars($client_data['state_province'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="postal_code">Postal Code</label>
                <input type="text" id="postal_code" name="postal_code"
                       value="<?php echo htmlspecialchars($client_data['postal_code'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="country">Country</label>
                <input type="text" id="country" name="country"
                       value="<?php echo htmlspecialchars($client_data['country'] ?? ''); ?>">
            </div>
        </div>
    </div>

    <!-- KYC Due Diligence Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-shield-alt"></i> KYC Due Diligence</div>

        <div class="form-row">
            <div class="form-group">
                <label for="kyc_status">KYC Status</label>
                <select id="kyc_status" name="kyc_status">
                    <option value="Pending" <?php echo ($client_data['kyc_status'] ?? '') == 'Pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="In Progress" <?php echo ($client_data['kyc_status'] ?? '') == 'In Progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="Completed" <?php echo ($client_data['kyc_status'] ?? '') == 'Completed' ? 'selected' : ''; ?>>Completed</option>
                    <option value="Expired" <?php echo ($client_data['kyc_status'] ?? '') == 'Expired' ? 'selected' : ''; ?>>Expired</option>
                </select>
            </div>

            <div class="form-group">
                <label for="kyc_completion_date">KYC Completion Date</label>
                <input type="date" id="kyc_completion_date" name="kyc_completion_date"
                       value="<?php echo htmlspecialchars($client_data['kyc_completion_date'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="kyc_expiry_date">KYC Expiry Date</label>
                <input type="date" id="kyc_expiry_date" name="kyc_expiry_date"
                       value="<?php echo htmlspecialchars($client_data['kyc_expiry_date'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="id_type">ID Type</label>
                <input type="text" id="id_type" name="id_type" placeholder="e.g., Passport, Driver's License"
                       value="<?php echo htmlspecialchars($client_data['id_type'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="id_number">ID Number</label>
                <input type="text" id="id_number" name="id_number"
                       value="<?php echo htmlspecialchars($client_data['id_number'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="id_expiry_date">ID Expiry Date</label>
                <input type="date" id="id_expiry_date" name="id_expiry_date"
                       value="<?php echo htmlspecialchars($client_data['id_expiry_date'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="tax_id">Tax ID</label>
                <input type="text" id="tax_id" name="tax_id"
                       value="<?php echo htmlspecialchars($client_data['tax_id'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="pep_status">PEP Status (Politically Exposed Person)</label>
                <select id="pep_status" name="pep_status">
                    <option value="Unknown" <?php echo ($client_data['pep_status'] ?? '') == 'Unknown' ? 'selected' : ''; ?>>Unknown</option>
                    <option value="No" <?php echo ($client_data['pep_status'] ?? '') == 'No' ? 'selected' : ''; ?>>No</option>
                    <option value="Yes" <?php echo ($client_data['pep_status'] ?? '') == 'Yes' ? 'selected' : ''; ?>>Yes</option>
                </select>
            </div>

            <div class="form-group">
                <label for="risk_rating">Risk Rating</label>
                <select id="risk_rating" name="risk_rating">
                    <option value="Low" <?php echo ($client_data['risk_rating'] ?? '') == 'Low' ? 'selected' : ''; ?>>Low</option>
                    <option value="Medium" <?php echo ($client_data['risk_rating'] ?? '') == 'Medium' ? 'selected' : ''; ?>>Medium</option>
                    <option value="High" <?php echo ($client_data['risk_rating'] ?? '') == 'High' ? 'selected' : ''; ?>>High</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Personal Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-user"></i> Personal Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="date_of_birth">Date of Birth</label>
                <input type="date" id="date_of_birth" name="date_of_birth"
                       value="<?php echo htmlspecialchars($client_data['date_of_birth'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="nationality">Nationality</label>
                <input type="text" id="nationality" name="nationality"
                       value="<?php echo htmlspecialchars($client_data['nationality'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="occupation">Occupation</label>
                <input type="text" id="occupation" name="occupation"
                       value="<?php echo htmlspecialchars($client_data['occupation'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="investor_profile">Investor Profile</label>
            <textarea id="investor_profile" name="investor_profile" rows="4"
                      placeholder="Short description of the investor's background and profile"><?php echo htmlspecialchars($client_data['investor_profile'] ?? ''); ?></textarea>
        </div>
    </div>

    <!-- Financial Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-dollar-sign"></i> Financial Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="annual_income">Annual Income</label>
                <input type="number" id="annual_income" name="annual_income" step="0.01"
                       value="<?php echo htmlspecialchars($client_data['annual_income'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="income_currency">Income Currency</label>
                <select id="income_currency" name="income_currency">
                    <option value="USD" <?php echo ($client_data['income_currency'] ?? 'USD') == 'USD' ? 'selected' : ''; ?>>USD</option>
                    <option value="EUR" <?php echo ($client_data['income_currency'] ?? '') == 'EUR' ? 'selected' : ''; ?>>EUR</option>
                    <option value="GBP" <?php echo ($client_data['income_currency'] ?? '') == 'GBP' ? 'selected' : ''; ?>>GBP</option>
                    <option value="JPY" <?php echo ($client_data['income_currency'] ?? '') == 'JPY' ? 'selected' : ''; ?>>JPY</option>
                    <option value="CHF" <?php echo ($client_data['income_currency'] ?? '') == 'CHF' ? 'selected' : ''; ?>>CHF</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="source_of_income">Source of Income</label>
            <textarea id="source_of_income" name="source_of_income" rows="3"
                      placeholder="e.g., Employment, Business ownership, Investments"><?php echo htmlspecialchars($client_data['source_of_income'] ?? ''); ?></textarea>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="total_net_worth">Total Net Worth</label>
                <input type="number" id="total_net_worth" name="total_net_worth" step="0.01"
                       value="<?php echo htmlspecialchars($client_data['total_net_worth'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="net_worth_currency">Net Worth Currency</label>
                <select id="net_worth_currency" name="net_worth_currency">
                    <option value="USD" <?php echo ($client_data['net_worth_currency'] ?? 'USD') == 'USD' ? 'selected' : ''; ?>>USD</option>
                    <option value="EUR" <?php echo ($client_data['net_worth_currency'] ?? '') == 'EUR' ? 'selected' : ''; ?>>EUR</option>
                    <option value="GBP" <?php echo ($client_data['net_worth_currency'] ?? '') == 'GBP' ? 'selected' : ''; ?>>GBP</option>
                    <option value="JPY" <?php echo ($client_data['net_worth_currency'] ?? '') == 'JPY' ? 'selected' : ''; ?>>JPY</option>
                    <option value="CHF" <?php echo ($client_data['net_worth_currency'] ?? '') == 'CHF' ? 'selected' : ''; ?>>CHF</option>
                </select>
            </div>

            <div class="form-group">
                <label for="liquid_assets">Liquid Assets</label>
                <input type="number" id="liquid_assets" name="liquid_assets" step="0.01"
                       value="<?php echo htmlspecialchars($client_data['liquid_assets'] ?? ''); ?>">
            </div>
        </div>
    </div>

    <!-- Investment Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-chart-line"></i> Investment Information</div>

        <div class="form-group">
            <label for="current_investments">Current Investments</label>
            <textarea id="current_investments" name="current_investments" rows="4"
                      placeholder="Details of existing investment portfolio"><?php echo htmlspecialchars($client_data['current_investments'] ?? ''); ?></textarea>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="investment_experience">Investment Experience</label>
                <select id="investment_experience" name="investment_experience">
                    <option value="None" <?php echo ($client_data['investment_experience'] ?? '') == 'None' ? 'selected' : ''; ?>>None</option>
                    <option value="Limited" <?php echo ($client_data['investment_experience'] ?? '') == 'Limited' ? 'selected' : ''; ?>>Limited</option>
                    <option value="Moderate" <?php echo ($client_data['investment_experience'] ?? '') == 'Moderate' ? 'selected' : ''; ?>>Moderate</option>
                    <option value="Extensive" <?php echo ($client_data['investment_experience'] ?? '') == 'Extensive' ? 'selected' : ''; ?>>Extensive</option>
                </select>
            </div>

            <div class="form-group">
                <label for="risk_tolerance">Risk Tolerance</label>
                <select id="risk_tolerance" name="risk_tolerance">
                    <option value="Conservative" <?php echo ($client_data['risk_tolerance'] ?? '') == 'Conservative' ? 'selected' : ''; ?>>Conservative</option>
                    <option value="Moderate" <?php echo ($client_data['risk_tolerance'] ?? '') == 'Moderate' ? 'selected' : ''; ?>>Moderate</option>
                    <option value="Aggressive" <?php echo ($client_data['risk_tolerance'] ?? '') == 'Aggressive' ? 'selected' : ''; ?>>Aggressive</option>
                </select>
            </div>

            <div class="form-group">
                <label for="investment_horizon">Investment Horizon</label>
                <select id="investment_horizon" name="investment_horizon">
                    <option value="Short-term" <?php echo ($client_data['investment_horizon'] ?? '') == 'Short-term' ? 'selected' : ''; ?>>Short-term</option>
                    <option value="Medium-term" <?php echo ($client_data['investment_horizon'] ?? '') == 'Medium-term' ? 'selected' : ''; ?>>Medium-term</option>
                    <option value="Long-term" <?php echo ($client_data['investment_horizon'] ?? '') == 'Long-term' ? 'selected' : ''; ?>>Long-term</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="investment_interests">Areas of Investment Interest</label>
            <textarea id="investment_interests" name="investment_interests" rows="4"
                      placeholder="e.g., Equities, Bonds, Real Estate, Private Equity, Hedge Funds"><?php echo htmlspecialchars($client_data['investment_interests'] ?? ''); ?></textarea>
        </div>

        <div class="form-group">
            <label for="investment_objectives">Investment Objectives</label>
            <textarea id="investment_objectives" name="investment_objectives" rows="4"
                      placeholder="Client's investment goals and objectives"><?php echo htmlspecialchars($client_data['investment_objectives'] ?? ''); ?></textarea>
        </div>
    </div>

    <!-- Additional Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-info-circle"></i> Additional Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="client_status">Client Status</label>
                <select id="client_status" name="client_status">
                    <option value="Prospect" <?php echo ($client_data['client_status'] ?? 'Prospect') == 'Prospect' ? 'selected' : ''; ?>>Prospect</option>
                    <option value="Active" <?php echo ($client_data['client_status'] ?? '') == 'Active' ? 'selected' : ''; ?>>Active</option>
                    <option value="Inactive" <?php echo ($client_data['client_status'] ?? '') == 'Inactive' ? 'selected' : ''; ?>>Inactive</option>
                    <option value="Closed" <?php echo ($client_data['client_status'] ?? '') == 'Closed' ? 'selected' : ''; ?>>Closed</option>
                </select>
            </div>

            <div class="form-group">
                <label for="owner_staff_id"><i class="fas fa-user-tie"></i> Client Owner (Staff)</label>
                <select id="owner_staff_id" name="owner_staff_id">
                    <option value="">-- Select Owner --</option>
                    <?php
                    mysqli_data_seek($staff_result, 0);
                    while($staff = $staff_result->fetch_assoc()):
                    ?>
                        <option value="<?php echo $staff['staff_id']; ?>"
                                <?php echo ($client_data['owner_staff_id'] ?? '') == $staff['staff_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="introducer_id"><i class="fas fa-handshake"></i> External Introducer</label>
                <select id="introducer_id" name="introducer_id">
                    <option value="">-- Select Introducer --</option>
                    <?php while($introducer = $introducers_result->fetch_assoc()): ?>
                        <option value="<?php echo $introducer['introducer_id']; ?>"
                                <?php echo ($client_data['introducer_id'] ?? '') == $introducer['introducer_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($introducer['company_name'] . ' (' . $introducer['contact_person'] . ')'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="assigned_staff_id">Assigned Staff Member</label>
                <select id="assigned_staff_id" name="assigned_staff_id">
                    <option value="">-- Select Staff Member --</option>
                    <?php
                    mysqli_data_seek($staff_result, 0);
                    while($staff = $staff_result->fetch_assoc()):
                    ?>
                        <option value="<?php echo $staff['staff_id']; ?>"
                                <?php echo ($client_data['assigned_staff_id'] ?? '') == $staff['staff_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="notes">Notes</label>
            <textarea id="notes" name="notes" rows="5"
                      placeholder="Additional notes and comments"><?php echo htmlspecialchars($client_data['notes'] ?? ''); ?></textarea>
        </div>
    </div>

    <div style="margin-top: 2rem;">
        <button type="submit" class="btn btn-success">
            <i class="fas fa-<?php echo $edit_mode ? 'save' : 'plus-circle'; ?>"></i>
            <?php echo $edit_mode ? 'Update Client' : 'Create Client'; ?>
        </button>
        <a href="../index.php" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
        <?php if ($edit_mode): ?>
            <a href="contact_records.php?client_id=<?php echo $client_data['client_id']; ?>" class="btn btn-primary"><i class="fas fa-phone-alt"></i> View Contact Records</a>
        <?php endif; ?>
    </div>
</form>

<?php
$conn->close();
include '../includes/footer.php';
?>
