<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Introducer Management';
$edit_mode = false;
$introducer_data = [];
$message = '';
$message_type = '';

// Check if editing existing introducer
if (isset($_GET['id'])) {
    $edit_mode = true;
    $introducer_id = intval($_GET['id']);

    $query = "SELECT * FROM introducers WHERE introducer_id = $introducer_id";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $introducer_data = $result->fetch_assoc();
    } else {
        $message = "Introducer not found.";
        $message_type = "error";
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize inputs
    $company_name = sanitize_input($_POST['company_name']);
    $contact_person = sanitize_input($_POST['contact_person']);
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $email = sanitize_input($_POST['email']);
    $phone = sanitize_input($_POST['phone']);
    $mobile = sanitize_input($_POST['mobile']);
    $address_line1 = sanitize_input($_POST['address_line1']);
    $address_line2 = sanitize_input($_POST['address_line2']);
    $city = sanitize_input($_POST['city']);
    $state_province = sanitize_input($_POST['state_province']);
    $postal_code = sanitize_input($_POST['postal_code']);
    $country = sanitize_input($_POST['country']);
    $website = sanitize_input($_POST['website']);

    // KYC Information
    $kyc_status = sanitize_input($_POST['kyc_status']);
    $kyc_completion_date = !empty($_POST['kyc_completion_date']) ? sanitize_input($_POST['kyc_completion_date']) : NULL;
    $kyc_expiry_date = !empty($_POST['kyc_expiry_date']) ? sanitize_input($_POST['kyc_expiry_date']) : NULL;
    $business_registration_number = sanitize_input($_POST['business_registration_number']);
    $tax_id = sanitize_input($_POST['tax_id']);
    $regulatory_license = sanitize_input($_POST['regulatory_license']);
    $license_expiry_date = !empty($_POST['license_expiry_date']) ? sanitize_input($_POST['license_expiry_date']) : NULL;
    $pep_status = sanitize_input($_POST['pep_status']);
    $risk_rating = sanitize_input($_POST['risk_rating']);

    // Business Information
    $business_type = sanitize_input($_POST['business_type']);
    $years_in_business = !empty($_POST['years_in_business']) ? intval($_POST['years_in_business']) : NULL;
    $number_of_clients = !empty($_POST['number_of_clients']) ? intval($_POST['number_of_clients']) : NULL;
    $commission_rate = !empty($_POST['commission_rate']) ? floatval($_POST['commission_rate']) : NULL;
    $commission_structure = sanitize_input($_POST['commission_structure']);

    // Additional Information
    $notes = sanitize_input($_POST['notes']);
    $introducer_status = sanitize_input($_POST['introducer_status']);
    $assigned_staff_id = !empty($_POST['assigned_staff_id']) ? intval($_POST['assigned_staff_id']) : NULL;

    if ($edit_mode && !empty($introducer_data)) {
        // Update existing introducer
        $update_query = "UPDATE introducers SET
            company_name = '$company_name',
            contact_person = '$contact_person',
            first_name = '$first_name',
            last_name = '$last_name',
            email = '$email',
            phone = '$phone',
            mobile = '$mobile',
            address_line1 = '$address_line1',
            address_line2 = '$address_line2',
            city = '$city',
            state_province = '$state_province',
            postal_code = '$postal_code',
            country = '$country',
            website = '$website',
            kyc_status = '$kyc_status',
            kyc_completion_date = " . ($kyc_completion_date ? "'$kyc_completion_date'" : "NULL") . ",
            kyc_expiry_date = " . ($kyc_expiry_date ? "'$kyc_expiry_date'" : "NULL") . ",
            business_registration_number = '$business_registration_number',
            tax_id = '$tax_id',
            regulatory_license = '$regulatory_license',
            license_expiry_date = " . ($license_expiry_date ? "'$license_expiry_date'" : "NULL") . ",
            pep_status = '$pep_status',
            risk_rating = '$risk_rating',
            business_type = '$business_type',
            years_in_business = " . ($years_in_business ? $years_in_business : "NULL") . ",
            number_of_clients = " . ($number_of_clients ? $number_of_clients : "NULL") . ",
            commission_rate = " . ($commission_rate ? $commission_rate : "NULL") . ",
            commission_structure = '$commission_structure',
            notes = '$notes',
            introducer_status = '$introducer_status',
            assigned_staff_id = " . ($assigned_staff_id ? $assigned_staff_id : "NULL") . "
            WHERE introducer_id = {$introducer_data['introducer_id']}";

        if ($conn->query($update_query) === TRUE) {
            $message = "Introducer updated successfully!";
            $message_type = "success";
            // Refresh introducer data
            $result = $conn->query("SELECT * FROM introducers WHERE introducer_id = {$introducer_data['introducer_id']}");
            $introducer_data = $result->fetch_assoc();
        } else {
            $message = "Error updating introducer: " . $conn->error;
            $message_type = "error";
        }
    } else {
        // Insert new introducer
        $insert_query = "INSERT INTO introducers (
            company_name, contact_person, first_name, last_name, email, phone, mobile,
            address_line1, address_line2, city, state_province, postal_code, country, website,
            kyc_status, kyc_completion_date, kyc_expiry_date, business_registration_number,
            tax_id, regulatory_license, license_expiry_date, pep_status, risk_rating,
            business_type, years_in_business, number_of_clients, commission_rate,
            commission_structure, notes, introducer_status, assigned_staff_id
        ) VALUES (
            '$company_name', '$contact_person', '$first_name', '$last_name', '$email',
            '$phone', '$mobile', '$address_line1', '$address_line2', '$city',
            '$state_province', '$postal_code', '$country', '$website',
            '$kyc_status', " . ($kyc_completion_date ? "'$kyc_completion_date'" : "NULL") . ",
            " . ($kyc_expiry_date ? "'$kyc_expiry_date'" : "NULL") . ",
            '$business_registration_number', '$tax_id', '$regulatory_license',
            " . ($license_expiry_date ? "'$license_expiry_date'" : "NULL") . ",
            '$pep_status', '$risk_rating', '$business_type',
            " . ($years_in_business ? $years_in_business : "NULL") . ",
            " . ($number_of_clients ? $number_of_clients : "NULL") . ",
            " . ($commission_rate ? $commission_rate : "NULL") . ",
            '$commission_structure', '$notes', '$introducer_status',
            " . ($assigned_staff_id ? $assigned_staff_id : "NULL") . "
        )";

        if ($conn->query($insert_query) === TRUE) {
            $message = "Introducer created successfully!";
            $message_type = "success";
            $new_introducer_id = $conn->insert_id;
            // Redirect to edit mode
            header("Location: introducer_form.php?id=$new_introducer_id");
            exit();
        } else {
            $message = "Error creating introducer: " . $conn->error;
            $message_type = "error";
        }
    }
}

// Get staff members for dropdown
$staff_query = "SELECT staff_id, first_name, last_name FROM staff WHERE active = 1 ORDER BY last_name, first_name";
$staff_result = $conn->query($staff_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-<?php echo $edit_mode ? 'edit' : 'handshake'; ?>"></i> <?php echo $edit_mode ? 'Edit Introducer' : 'Add New Introducer'; ?></h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<form method="POST" action="">

    <!-- Company Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-building"></i> Company Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="company_name">Company Name</label>
                <input type="text" id="company_name" name="company_name"
                       value="<?php echo htmlspecialchars($introducer_data['company_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="business_type">Business Type</label>
                <input type="text" id="business_type" name="business_type"
                       value="<?php echo htmlspecialchars($introducer_data['business_type'] ?? ''); ?>"
                       placeholder="e.g., Financial Advisor, Wealth Manager">
            </div>

            <div class="form-group">
                <label for="years_in_business">Years in Business</label>
                <input type="number" id="years_in_business" name="years_in_business"
                       value="<?php echo htmlspecialchars($introducer_data['years_in_business'] ?? ''); ?>">
            </div>
        </div>
    </div>

    <!-- Contact Person Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-user"></i> Contact Person</div>

        <div class="form-row">
            <div class="form-group">
                <label for="contact_person">Contact Person *</label>
                <input type="text" id="contact_person" name="contact_person" required
                       value="<?php echo htmlspecialchars($introducer_data['contact_person'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="first_name">First Name</label>
                <input type="text" id="first_name" name="first_name"
                       value="<?php echo htmlspecialchars($introducer_data['first_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="last_name">Last Name</label>
                <input type="text" id="last_name" name="last_name"
                       value="<?php echo htmlspecialchars($introducer_data['last_name'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="email">Email *</label>
                <input type="email" id="email" name="email" required
                       value="<?php echo htmlspecialchars($introducer_data['email'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="tel" id="phone" name="phone"
                       value="<?php echo htmlspecialchars($introducer_data['phone'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="mobile">Mobile</label>
                <input type="tel" id="mobile" name="mobile"
                       value="<?php echo htmlspecialchars($introducer_data['mobile'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="website">Website</label>
            <input type="text" id="website" name="website"
                   value="<?php echo htmlspecialchars($introducer_data['website'] ?? ''); ?>"
                   placeholder="https://www.example.com">
        </div>
    </div>

    <!-- Address Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-map-marker-alt"></i> Address</div>

        <div class="form-row">
            <div class="form-group">
                <label for="address_line1">Address Line 1</label>
                <input type="text" id="address_line1" name="address_line1"
                       value="<?php echo htmlspecialchars($introducer_data['address_line1'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="address_line2">Address Line 2</label>
                <input type="text" id="address_line2" name="address_line2"
                       value="<?php echo htmlspecialchars($introducer_data['address_line2'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="city">City</label>
                <input type="text" id="city" name="city"
                       value="<?php echo htmlspecialchars($introducer_data['city'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="state_province">State/Province</label>
                <input type="text" id="state_province" name="state_province"
                       value="<?php echo htmlspecialchars($introducer_data['state_province'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="postal_code">Postal Code</label>
                <input type="text" id="postal_code" name="postal_code"
                       value="<?php echo htmlspecialchars($introducer_data['postal_code'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="country">Country</label>
                <input type="text" id="country" name="country"
                       value="<?php echo htmlspecialchars($introducer_data['country'] ?? ''); ?>">
            </div>
        </div>
    </div>

    <!-- KYC Due Diligence Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-shield-alt"></i> KYC Due Diligence</div>

        <div class="form-row">
            <div class="form-group">
                <label for="kyc_status">KYC Status</label>
                <select id="kyc_status" name="kyc_status">
                    <option value="Pending" <?php echo ($introducer_data['kyc_status'] ?? '') == 'Pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="In Progress" <?php echo ($introducer_data['kyc_status'] ?? '') == 'In Progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="Completed" <?php echo ($introducer_data['kyc_status'] ?? '') == 'Completed' ? 'selected' : ''; ?>>Completed</option>
                    <option value="Expired" <?php echo ($introducer_data['kyc_status'] ?? '') == 'Expired' ? 'selected' : ''; ?>>Expired</option>
                </select>
            </div>

            <div class="form-group">
                <label for="kyc_completion_date">KYC Completion Date</label>
                <input type="date" id="kyc_completion_date" name="kyc_completion_date"
                       value="<?php echo htmlspecialchars($introducer_data['kyc_completion_date'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="kyc_expiry_date">KYC Expiry Date</label>
                <input type="date" id="kyc_expiry_date" name="kyc_expiry_date"
                       value="<?php echo htmlspecialchars($introducer_data['kyc_expiry_date'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="business_registration_number">Business Registration Number</label>
                <input type="text" id="business_registration_number" name="business_registration_number"
                       value="<?php echo htmlspecialchars($introducer_data['business_registration_number'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="tax_id">Tax ID</label>
                <input type="text" id="tax_id" name="tax_id"
                       value="<?php echo htmlspecialchars($introducer_data['tax_id'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="regulatory_license">Regulatory License Number</label>
                <input type="text" id="regulatory_license" name="regulatory_license"
                       value="<?php echo htmlspecialchars($introducer_data['regulatory_license'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="license_expiry_date">License Expiry Date</label>
                <input type="date" id="license_expiry_date" name="license_expiry_date"
                       value="<?php echo htmlspecialchars($introducer_data['license_expiry_date'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="pep_status">PEP Status</label>
                <select id="pep_status" name="pep_status">
                    <option value="Unknown" <?php echo ($introducer_data['pep_status'] ?? '') == 'Unknown' ? 'selected' : ''; ?>>Unknown</option>
                    <option value="No" <?php echo ($introducer_data['pep_status'] ?? '') == 'No' ? 'selected' : ''; ?>>No</option>
                    <option value="Yes" <?php echo ($introducer_data['pep_status'] ?? '') == 'Yes' ? 'selected' : ''; ?>>Yes</option>
                </select>
            </div>

            <div class="form-group">
                <label for="risk_rating">Risk Rating</label>
                <select id="risk_rating" name="risk_rating">
                    <option value="Low" <?php echo ($introducer_data['risk_rating'] ?? '') == 'Low' ? 'selected' : ''; ?>>Low</option>
                    <option value="Medium" <?php echo ($introducer_data['risk_rating'] ?? 'Medium') == 'Medium' ? 'selected' : ''; ?>>Medium</option>
                    <option value="High" <?php echo ($introducer_data['risk_rating'] ?? '') == 'High' ? 'selected' : ''; ?>>High</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Business Details Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-briefcase"></i> Business Details</div>

        <div class="form-row">
            <div class="form-group">
                <label for="number_of_clients">Number of Clients</label>
                <input type="number" id="number_of_clients" name="number_of_clients"
                       value="<?php echo htmlspecialchars($introducer_data['number_of_clients'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="commission_rate">Commission Rate (%)</label>
                <input type="number" id="commission_rate" name="commission_rate" step="0.01"
                       value="<?php echo htmlspecialchars($introducer_data['commission_rate'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-group">
            <label for="commission_structure">Commission Structure</label>
            <textarea id="commission_structure" name="commission_structure" rows="3"
                      placeholder="Details of commission structure and payment terms"><?php echo htmlspecialchars($introducer_data['commission_structure'] ?? ''); ?></textarea>
        </div>
    </div>

    <!-- Additional Information Section -->
    <div class="card">
        <div class="card-header"><i class="fas fa-info-circle"></i> Additional Information</div>

        <div class="form-row">
            <div class="form-group">
                <label for="introducer_status">Introducer Status</label>
                <select id="introducer_status" name="introducer_status">
                    <option value="Active" <?php echo ($introducer_data['introducer_status'] ?? 'Active') == 'Active' ? 'selected' : ''; ?>>Active</option>
                    <option value="Inactive" <?php echo ($introducer_data['introducer_status'] ?? '') == 'Inactive' ? 'selected' : ''; ?>>Inactive</option>
                    <option value="Suspended" <?php echo ($introducer_data['introducer_status'] ?? '') == 'Suspended' ? 'selected' : ''; ?>>Suspended</option>
                </select>
            </div>

            <div class="form-group">
                <label for="assigned_staff_id">Assigned Staff Member</label>
                <select id="assigned_staff_id" name="assigned_staff_id">
                    <option value="">-- Select Staff Member --</option>
                    <?php while($staff = $staff_result->fetch_assoc()): ?>
                        <option value="<?php echo $staff['staff_id']; ?>"
                                <?php echo ($introducer_data['assigned_staff_id'] ?? '') == $staff['staff_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="notes">Notes</label>
            <textarea id="notes" name="notes" rows="5"
                      placeholder="Additional notes and comments"><?php echo htmlspecialchars($introducer_data['notes'] ?? ''); ?></textarea>
        </div>
    </div>

    <div style="margin-top: 2rem;">
        <button type="submit" class="btn btn-success">
            <i class="fas fa-<?php echo $edit_mode ? 'save' : 'plus-circle'; ?>"></i>
            <?php echo $edit_mode ? 'Update Introducer' : 'Create Introducer'; ?>
        </button>
        <a href="introducers_list.php" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
    </div>
</form>

<?php
$conn->close();
include '../includes/footer.php';
?>
