<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

$page_title = 'Introducers';

// Get all introducers
$introducers_query = "SELECT i.*, s.first_name as staff_first, s.last_name as staff_last,
                      (SELECT COUNT(*) FROM clients WHERE introducer_id = i.introducer_id) as client_count
                      FROM introducers i
                      LEFT JOIN staff s ON i.assigned_staff_id = s.staff_id
                      ORDER BY i.company_name, i.contact_person";
$introducers_result = $conn->query($introducers_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-handshake"></i> Introducers</h2>

<div style="margin-bottom: 1.5rem;">
    <a href="introducer_form.php" class="btn btn-success">
        <i class="fas fa-plus-circle"></i> Add New Introducer
    </a>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-list"></i> All Introducers</div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Company Name</th>
                    <th>Contact Person</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>City</th>
                    <th>KYC Status</th>
                    <th>Clients</th>
                    <th>Assigned Staff</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($introducers_result->num_rows > 0): ?>
                    <?php while($row = $introducers_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['introducer_id']; ?></td>
                            <td><strong><?php echo htmlspecialchars($row['company_name'] ?? 'N/A'); ?></strong></td>
                            <td><?php echo htmlspecialchars($row['contact_person']); ?></td>
                            <td><?php echo htmlspecialchars($row['email']); ?></td>
                            <td><?php echo htmlspecialchars($row['phone'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($row['city'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="badge badge-<?php echo strtolower($row['kyc_status']); ?>">
                                    <?php echo $row['kyc_status']; ?>
                                </span>
                            </td>
                            <td><?php echo $row['client_count']; ?></td>
                            <td><?php echo $row['staff_first'] ? htmlspecialchars($row['staff_first'] . ' ' . $row['staff_last']) : 'Unassigned'; ?></td>
                            <td>
                                <span class="badge badge-<?php echo strtolower($row['introducer_status']); ?>">
                                    <?php echo $row['introducer_status']; ?>
                                </span>
                            </td>
                            <td>
                                <a href="introducer_form.php?id=<?php echo $row['introducer_id']; ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="11" style="text-align: center; padding: 2rem; color: #95a5a6;">
                            <i class="fas fa-inbox" style="font-size: 3rem; opacity: 0.3;"></i>
                            <p>No introducers found</p>
                            <a href="introducer_form.php" class="btn btn-success" style="margin-top: 1rem;">
                                <i class="fas fa-plus-circle"></i> Add First Introducer
                            </a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
