<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/auth.php';

require_login();

$page_title = 'My Profile';
$message = '';
$message_type = '';

$user_id = $_SESSION['user_id'];

// Get current user data
$query = "SELECT u.*, s.first_name as staff_first, s.last_name as staff_last
          FROM users u
          LEFT JOIN staff s ON u.staff_id = s.staff_id
          WHERE u.user_id = $user_id";
$result = $conn->query($query);
$user_data = $result->fetch_assoc();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = sanitize_input($_POST['email']);
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $phone = sanitize_input($_POST['phone']);

    $update_query = "UPDATE users SET
        email = '$email',
        first_name = '$first_name',
        last_name = '$last_name',
        phone = '$phone',
        updated_by = $user_id
        WHERE user_id = $user_id";

    if ($conn->query($update_query) === TRUE) {
        // Update session variables
        $_SESSION['first_name'] = $first_name;
        $_SESSION['last_name'] = $last_name;
        $_SESSION['email'] = $email;

        log_activity($user_id, 'update_profile', 'user', $user_id, 'Updated own profile');

        $message = "Profile updated successfully!";
        $message_type = "success";

        // Refresh user data
        $result = $conn->query($query);
        $user_data = $result->fetch_assoc();
    } else {
        $message = "Error updating profile: " . $conn->error;
        $message_type = "error";
    }
}

// Get user's activity summary
$activity_query = "SELECT
    COUNT(*) as total_actions,
    COUNT(DISTINCT CASE WHEN action = 'login' THEN log_id END) as login_count,
    COUNT(DISTINCT CASE WHEN entity_type = 'client' THEN entity_id END) as clients_worked,
    COUNT(DISTINCT CASE WHEN entity_type = 'contact_record' THEN entity_id END) as contacts_made,
    MAX(CASE WHEN action = 'login' THEN created_at END) as last_login_date
    FROM activity_log
    WHERE user_id = $user_id";
$activity_result = $conn->query($activity_query);
$activity_stats = $activity_result->fetch_assoc();

include '../includes/header.php';
?>

<h2><i class="fas fa-user-circle"></i> My Profile</h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
    <div>
        <div class="card">
            <div class="card-header"><i class="fas fa-user-edit"></i> Edit Profile Information</div>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="username"><i class="fas fa-user"></i> Username</label>
                    <input type="text" id="username" value="<?php echo htmlspecialchars($user_data['username']); ?>" disabled
                           style="background: #f8f9fa; cursor: not-allowed;">
                    <small style="display: block; margin-top: 0.25rem; color: #666;">
                        Username cannot be changed. Contact admin if needed.
                    </small>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="first_name"><i class="fas fa-user"></i> First Name *</label>
                        <input type="text" id="first_name" name="first_name" required
                               value="<?php echo htmlspecialchars($user_data['first_name']); ?>">
                    </div>

                    <div class="form-group">
                        <label for="last_name"><i class="fas fa-user"></i> Last Name *</label>
                        <input type="text" id="last_name" name="last_name" required
                               value="<?php echo htmlspecialchars($user_data['last_name']); ?>">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="email"><i class="fas fa-envelope"></i> Email *</label>
                        <input type="email" id="email" name="email" required
                               value="<?php echo htmlspecialchars($user_data['email']); ?>">
                    </div>

                    <div class="form-group">
                        <label for="phone"><i class="fas fa-phone"></i> Phone</label>
                        <input type="tel" id="phone" name="phone"
                               value="<?php echo htmlspecialchars($user_data['phone']); ?>">
                    </div>
                </div>

                <div style="margin-top: 2rem;">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save"></i> Update Profile
                    </button>
                    <a href="../index.php" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card-header"><i class="fas fa-key"></i> Security</div>

            <div style="padding: 1.5rem;">
                <p><strong>Password:</strong> ********</p>
                <p style="margin: 1rem 0;">Last password change: <?php echo $user_data['last_password_change'] ? date('Y-m-d H:i', strtotime($user_data['last_password_change'])) : 'Unknown'; ?></p>

                <a href="change_password.php" class="btn btn-primary">
                    <i class="fas fa-key"></i> Change Password
                </a>
            </div>
        </div>
    </div>

    <div>
        <div class="card">
            <div class="card-header"><i class="fas fa-info-circle"></i> Account Information</div>

            <div style="padding: 1.5rem; line-height: 2;">
                <p><strong>User ID:</strong> <?php echo $user_data['user_id']; ?></p>
                <p><strong>Role:</strong>
                    <span class="badge" style="background: <?php
                        echo $user_data['role'] == 'Admin' ? '#e74c3c' :
                             ($user_data['role'] == 'Manager' ? '#3498db' :
                             ($user_data['role'] == 'User' ? '#27ae60' : '#95a5a6'));
                    ?>; color: white;">
                        <?php echo $user_data['role']; ?>
                    </span>
                </p>
                <p><strong>Status:</strong>
                    <span class="badge badge-<?php echo strtolower($user_data['status']); ?>">
                        <?php echo $user_data['status']; ?>
                    </span>
                </p>
                <p><strong>Linked Staff:</strong>
                    <?php echo $user_data['staff_first'] ? htmlspecialchars($user_data['staff_first'] . ' ' . $user_data['staff_last']) : 'None'; ?>
                </p>
                <p><strong>Email Verified:</strong>
                    <?php echo $user_data['email_verified'] ? '<span style="color: #27ae60;">✓ Yes</span>' : '<span style="color: #e74c3c;">✗ No</span>'; ?>
                </p>
                <p><strong>Account Created:</strong> <?php echo date('Y-m-d', strtotime($user_data['created_at'])); ?></p>
            </div>
        </div>

        <div class="card">
            <div class="card-header"><i class="fas fa-chart-bar"></i> Activity Summary</div>

            <div style="padding: 1.5rem; line-height: 2;">
                <p><strong>Last Login:</strong>
                    <?php echo $activity_stats['last_login_date'] ? date('Y-m-d H:i', strtotime($activity_stats['last_login_date'])) : 'Never'; ?>
                </p>
                <p><strong>Total Logins:</strong> <?php echo $activity_stats['login_count'] ?? 0; ?></p>
                <p><strong>Total Actions:</strong> <?php echo $activity_stats['total_actions'] ?? 0; ?></p>
                <p><strong>Clients Worked:</strong> <?php echo $activity_stats['clients_worked'] ?? 0; ?></p>
                <p><strong>Contacts Made:</strong> <?php echo $activity_stats['contacts_made'] ?? 0; ?></p>
            </div>
        </div>
    </div>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
