<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/auth.php';

require_role('Admin'); // Only admins can manage users

$page_title = 'User Management';
$message = '';
$message_type = '';
$edit_mode = false;
$user_data = [];

// Check if editing existing user
if (isset($_GET['id'])) {
    $edit_mode = true;
    $edit_user_id = intval($_GET['id']);

    $query = "SELECT * FROM users WHERE user_id = $edit_user_id";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();
    } else {
        $message = "User not found.";
        $message_type = "error";
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = sanitize_input($_POST['username']);
    $email = sanitize_input($_POST['email']);
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $phone = sanitize_input($_POST['phone']);
    $role = sanitize_input($_POST['role']);
    $status = sanitize_input($_POST['status']);
    $staff_id = !empty($_POST['staff_id']) ? intval($_POST['staff_id']) : NULL;
    $current_user_id = $_SESSION['user_id'];

    if ($edit_mode && !empty($user_data)) {
        // Update existing user
        $update_query = "UPDATE users SET
            username = '$username',
            email = '$email',
            first_name = '$first_name',
            last_name = '$last_name',
            phone = '$phone',
            role = '$role',
            status = '$status',
            staff_id = " . ($staff_id ? $staff_id : "NULL") . ",
            updated_by = $current_user_id
            WHERE user_id = {$user_data['user_id']}";

        // Update password if provided
        if (!empty($_POST['new_password'])) {
            $password_hash = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
            $conn->query("UPDATE users SET password_hash = '$password_hash', last_password_change = NOW() WHERE user_id = {$user_data['user_id']}");
        }

        if ($conn->query($update_query) === TRUE) {
            log_activity($current_user_id, 'update_user', 'user', $user_data['user_id'], "Updated user: $username");
            $message = "User updated successfully!";
            $message_type = "success";

            // Refresh user data
            $result = $conn->query("SELECT * FROM users WHERE user_id = {$user_data['user_id']}");
            $user_data = $result->fetch_assoc();
        } else {
            $message = "Error updating user: " . $conn->error;
            $message_type = "error";
        }
    } else {
        // Insert new user
        if (empty($_POST['password'])) {
            $message = "Password is required for new users.";
            $message_type = "error";
        } else {
            $password_hash = password_hash($_POST['password'], PASSWORD_DEFAULT);

            $insert_query = "INSERT INTO users (
                username, email, password_hash, first_name, last_name, phone,
                role, status, staff_id, created_by, email_verified
            ) VALUES (
                '$username', '$email', '$password_hash', '$first_name', '$last_name', '$phone',
                '$role', '$status', " . ($staff_id ? $staff_id : "NULL") . ", $current_user_id, 1
            )";

            if ($conn->query($insert_query) === TRUE) {
                $new_user_id = $conn->insert_id;
                log_activity($current_user_id, 'create_user', 'user', $new_user_id, "Created user: $username");
                $message = "User created successfully!";
                $message_type = "success";

                // Redirect to edit mode
                header("Location: user_management.php?id=$new_user_id");
                exit();
            } else {
                $message = "Error creating user: " . $conn->error;
                $message_type = "error";
            }
        }
    }
}

// Get all staff for dropdown
$staff_query = "SELECT staff_id, first_name, last_name FROM staff WHERE active = 1 ORDER BY last_name, first_name";
$staff_result = $conn->query($staff_query);

// Get all users
$users_query = "SELECT u.*, s.first_name as staff_first, s.last_name as staff_last
                FROM users u
                LEFT JOIN staff s ON u.staff_id = s.staff_id
                ORDER BY u.username";
$users_result = $conn->query($users_query);

include '../includes/header.php';
?>

<h2><i class="fas fa-<?php echo $edit_mode ? 'user-edit' : 'users-cog'; ?>"></i> <?php echo $edit_mode ? 'Edit User' : 'User Management'; ?></h2>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $message_type; ?>">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header"><i class="fas fa-user-<?php echo $edit_mode ? 'edit' : 'plus'; ?>"></i> <?php echo $edit_mode ? 'Edit User' : 'Add New User'; ?></div>

    <form method="POST" action="">
        <div class="form-row">
            <div class="form-group">
                <label for="username"><i class="fas fa-user"></i> Username *</label>
                <input type="text" id="username" name="username" required
                       value="<?php echo htmlspecialchars($user_data['username'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="email"><i class="fas fa-envelope"></i> Email *</label>
                <input type="email" id="email" name="email" required
                       value="<?php echo htmlspecialchars($user_data['email'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="first_name"><i class="fas fa-user"></i> First Name *</label>
                <input type="text" id="first_name" name="first_name" required
                       value="<?php echo htmlspecialchars($user_data['first_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="last_name"><i class="fas fa-user"></i> Last Name *</label>
                <input type="text" id="last_name" name="last_name" required
                       value="<?php echo htmlspecialchars($user_data['last_name'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label for="phone"><i class="fas fa-phone"></i> Phone</label>
                <input type="tel" id="phone" name="phone"
                       value="<?php echo htmlspecialchars($user_data['phone'] ?? ''); ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="role"><i class="fas fa-user-shield"></i> Role *</label>
                <select id="role" name="role" required>
                    <option value="Viewer" <?php echo ($user_data['role'] ?? '') == 'Viewer' ? 'selected' : ''; ?>>Viewer (Read-only)</option>
                    <option value="User" <?php echo ($user_data['role'] ?? '') == 'User' ? 'selected' : ''; ?>>User (Basic access)</option>
                    <option value="Manager" <?php echo ($user_data['role'] ?? '') == 'Manager' ? 'selected' : ''; ?>>Manager (Full access)</option>
                    <option value="Admin" <?php echo ($user_data['role'] ?? '') == 'Admin' ? 'selected' : ''; ?>>Admin (All permissions)</option>
                </select>
            </div>

            <div class="form-group">
                <label for="status"><i class="fas fa-toggle-on"></i> Status *</label>
                <select id="status" name="status" required>
                    <option value="Active" <?php echo ($user_data['status'] ?? 'Active') == 'Active' ? 'selected' : ''; ?>>Active</option>
                    <option value="Inactive" <?php echo ($user_data['status'] ?? '') == 'Inactive' ? 'selected' : ''; ?>>Inactive</option>
                    <option value="Suspended" <?php echo ($user_data['status'] ?? '') == 'Suspended' ? 'selected' : ''; ?>>Suspended</option>
                    <option value="Locked" <?php echo ($user_data['status'] ?? '') == 'Locked' ? 'selected' : ''; ?>>Locked</option>
                </select>
            </div>

            <div class="form-group">
                <label for="staff_id"><i class="fas fa-user-tie"></i> Linked Staff Member</label>
                <select id="staff_id" name="staff_id">
                    <option value="">-- None --</option>
                    <?php
                    mysqli_data_seek($staff_result, 0);
                    while($staff = $staff_result->fetch_assoc()):
                    ?>
                        <option value="<?php echo $staff['staff_id']; ?>"
                                <?php echo ($user_data['staff_id'] ?? '') == $staff['staff_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </div>

        <div class="section-divider"></div>

        <?php if ($edit_mode): ?>
            <div class="form-group">
                <label for="new_password"><i class="fas fa-key"></i> New Password</label>
                <input type="password" id="new_password" name="new_password" minlength="8"
                       placeholder="Leave blank to keep current password">
                <small style="display: block; margin-top: 0.25rem; color: #666;">
                    Only enter a password if you want to change it. Minimum 8 characters.
                </small>
            </div>
        <?php else: ?>
            <div class="form-group">
                <label for="password"><i class="fas fa-key"></i> Password *</label>
                <input type="password" id="password" name="password" required minlength="8"
                       placeholder="Minimum 8 characters">
            </div>
        <?php endif; ?>

        <div style="margin-top: 2rem;">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-<?php echo $edit_mode ? 'save' : 'user-plus'; ?>"></i>
                <?php echo $edit_mode ? 'Update User' : 'Create User'; ?>
            </button>
            <a href="user_management.php" class="btn btn-secondary">
                <i class="fas fa-times"></i> <?php echo $edit_mode ? 'Cancel' : 'Clear'; ?>
            </a>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-users"></i> All Users</div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Linked Staff</th>
                    <th>Last Login</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($users_result->num_rows > 0): ?>
                    <?php while($user = $users_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $user['user_id']; ?></td>
                            <td><strong><?php echo htmlspecialchars($user['username']); ?></strong></td>
                            <td><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></td>
                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                            <td>
                                <span class="badge badge-<?php echo strtolower($user['role']); ?>"
                                      style="background: <?php
                                      echo $user['role'] == 'Admin' ? '#e74c3c' :
                                           ($user['role'] == 'Manager' ? '#3498db' :
                                           ($user['role'] == 'User' ? '#27ae60' : '#95a5a6')); ?>; color: white;">
                                    <?php echo $user['role']; ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo strtolower($user['status']); ?>">
                                    <?php echo $user['status']; ?>
                                </span>
                            </td>
                            <td><?php echo $user['staff_first'] ? htmlspecialchars($user['staff_first'] . ' ' . $user['staff_last']) : '-'; ?></td>
                            <td><?php echo $user['last_login'] ? date('Y-m-d H:i', strtotime($user['last_login'])) : 'Never'; ?></td>
                            <td><?php echo date('Y-m-d', strtotime($user['created_at'])); ?></td>
                            <td>
                                <a href="user_management.php?id=<?php echo $user['user_id']; ?>" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="10" style="text-align: center;">No users found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
$conn->close();
include '../includes/footer.php';
?>
