<?php
require_once 'includes/config.php';
require_once 'includes/db.php';

$page_title = 'Dashboard';

// Get statistics
$total_clients_query = "SELECT COUNT(*) as count FROM clients";
$total_clients = $conn->query($total_clients_query)->fetch_assoc()['count'];

$active_clients_query = "SELECT COUNT(*) as count FROM clients WHERE client_status = 'Active'";
$active_clients = $conn->query($active_clients_query)->fetch_assoc()['count'];

$prospect_clients_query = "SELECT COUNT(*) as count FROM clients WHERE client_status = 'Prospect'";
$prospect_clients = $conn->query($prospect_clients_query)->fetch_assoc()['count'];

$total_contacts_query = "SELECT COUNT(*) as count FROM contact_records";
$total_contacts = $conn->query($total_contacts_query)->fetch_assoc()['count'];

$pending_kyc_query = "SELECT COUNT(*) as count FROM clients WHERE kyc_status IN ('Pending', 'In Progress')";
$pending_kyc = $conn->query($pending_kyc_query)->fetch_assoc()['count'];

// Get recent clients
$recent_clients_query = "SELECT c.client_id, c.first_name, c.last_name, c.email, c.client_status, c.created_at,
                         o.first_name as owner_first, o.last_name as owner_last,
                         i.company_name as introducer_company
                         FROM clients c
                         LEFT JOIN staff o ON c.owner_staff_id = o.staff_id
                         LEFT JOIN introducers i ON c.introducer_id = i.introducer_id
                         ORDER BY c.created_at DESC
                         LIMIT 10";
$recent_clients = $conn->query($recent_clients_query);

// Get recent contacts
$recent_contacts_query = "SELECT cr.contact_id, cr.contact_date, cr.contact_type, cr.subject,
                          c.first_name as client_first, c.last_name as client_last,
                          s.first_name as staff_first, s.last_name as staff_last
                          FROM contact_records cr
                          JOIN clients c ON cr.client_id = c.client_id
                          JOIN staff s ON cr.staff_id = s.staff_id
                          ORDER BY cr.contact_date DESC
                          LIMIT 10";
$recent_contacts = $conn->query($recent_contacts_query);

include 'includes/header.php';
?>

<h2><i class="fas fa-tachometer-alt"></i> Dashboard</h2>

<div class="stats-grid">
    <a href="forms/search_clients.php" class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
        <i class="fas fa-users"></i>
        <h3><?php echo $total_clients; ?></h3>
        <p>Total Clients</p>
    </a>
    <a href="forms/search_clients.php?client_status=Active" class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
        <i class="fas fa-user-check"></i>
        <h3><?php echo $active_clients; ?></h3>
        <p>Active Clients</p>
    </a>
    <a href="forms/search_clients.php?client_status=Prospect" class="stat-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
        <i class="fas fa-user-clock"></i>
        <h3><?php echo $prospect_clients; ?></h3>
        <p>Prospects</p>
    </a>
    <a href="forms/contact_records.php" class="stat-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
        <i class="fas fa-phone-volume"></i>
        <h3><?php echo $total_contacts; ?></h3>
        <p>Total Contacts</p>
    </a>
    <a href="forms/search_clients.php?kyc_status=Pending" class="stat-card" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
        <i class="fas fa-exclamation-triangle"></i>
        <h3><?php echo $pending_kyc; ?></h3>
        <p>Pending KYC</p>
    </a>
</div>

<div class="section-divider"></div>

<div class="card">
    <div class="card-header"><i class="fas fa-user-friends"></i> Recent Clients</div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Owner</th>
                    <th>Introducer</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($recent_clients->num_rows > 0): ?>
                    <?php while($row = $recent_clients->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['client_id']; ?></td>
                            <td><?php echo htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['email']); ?></td>
                            <td><span class="badge badge-<?php echo strtolower($row['client_status']); ?>"><?php echo $row['client_status']; ?></span></td>
                            <td>
                                <?php
                                    if (!empty($row['owner_first']) || !empty($row['owner_last'])) {
                                        echo htmlspecialchars(trim($row['owner_first'] . ' ' . $row['owner_last']));
                                    } else {
                                        echo '<span style="color:#aaa;">-</span>';
                                    }
                                ?>
                            </td>
                            <td>
                                <?php
                                    if (!empty($row['introducer_company'])) {
                                        echo htmlspecialchars($row['introducer_company']);
                                    } else {
                                        echo '<span style="color:#aaa;">-</span>';
                                    }
                                ?>
                            </td>
                            <td><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></td>
                            <td>
                                <a href="forms/client_form.php?id=<?php echo $row['client_id']; ?>" class="btn btn-primary btn-sm"><i class="fas fa-eye"></i> View</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center; padding: 2rem; color: #95a5a6;">
                            <i class="fas fa-inbox" style="font-size: 3rem; opacity: 0.3;"></i>
                            <p>No clients found</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="card">
    <div class="card-header"><i class="fas fa-history"></i> Recent Contact Records</div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Client</th>
                    <th>Type</th>
                    <th>Subject</th>
                    <th>Staff Member</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($recent_contacts->num_rows > 0): ?>
                    <?php while($row = $recent_contacts->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo date('Y-m-d H:i', strtotime($row['contact_date'])); ?></td>
                            <td><?php echo htmlspecialchars($row['client_first'] . ' ' . $row['client_last']); ?></td>
                            <td><?php echo $row['contact_type']; ?></td>
                            <td><?php echo htmlspecialchars($row['subject']); ?></td>
                            <td><?php echo htmlspecialchars($row['staff_first'] . ' ' . $row['staff_last']); ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align: center;">No contact records found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
$conn->close();
include 'includes/footer.php';
?>
